import yaml
import os
import ipaddress

# charge une config YAML depuis un fichier
# si le fichier n'existe pas et create=True, crée un fichier minimal par défaut
def load_config(filename, create):
    minimal_config = {
        "dhcp_hosts_cfg": "/etc/dnsmasq.d/hosts.conf",
        "user": "dhcp-mod"
    }

    if os.path.exists(filename):
        # le fichier existe -> on le lit et on charge le YAML
        with open(filename, "r") as f:
            config = yaml.safe_load(f)
        return config
    else:
        if create == True:
            # le fichier n'existe pas -> on le crée avec une config de base
            with open(filename, "w") as f:
                yaml.dump(minimal_config, f)
            return minimal_config
        else:
            # ni fichier ni création -> on affiche une erreur et on renvoie None
            print("Error the file doesn't exist or the create parameter is FALSE")
            return None

# cherche le serveur DHCP correspondant à une ip donnée
# en parcourant la liste des réseaux déclarés
def get_dhcp_server(ip, cfg):
    ip_addr = ipaddress.IPv4Address(ip)  # convertit en objet IPv4
    for server_ip, network_str in cfg.get("dhcp-servers", {}).items():
        network = ipaddress.IPv4Network(network_str)
        if ip_addr in network:
            # l'ip appartient à ce réseau -> retourne ce serveur
            return {server_ip: network_str}
        
    return None # si aucune ip correspond -> return None
