#!/usr/bin/env python3


import sys
from validation import if_macvalide  
from dhcp import dhcp_remove, mac_exists 
from config import load_config  
from fabric import Connection  
from paramiko.ssh_exception import NoValidConnectionsError, SSHException  


def main():
    # récupère l'argument MAC depuis la ligne de commande
    mac = sys.argv[1]

    # vérifie si l'adresse MAC est bien formatée
    if if_macvalide(mac):
        # charge la configuration du superviseur
        config = load_config('config_superviseur.yaml', True)

        # parcourt tous les serveurs DHCP définis
        for server_ip in config.get("dhcp-servers", {}).keys():
            # crée une connexion SSH au serveur en cours
            cnx = Connection(host=server_ip, user='dhcp-mod')
            try:
                # vérifie si la MAC existe sur ce serveur
                if mac_exists(cnx, mac, config):
                    # si oui, supprime l'entrée et quitte avec succès
                    dhcp_remove(mac, server_ip, config)
                    sys.exit(0)

            # gestion des erreurs de connexion SSH
            except NoValidConnectionsError:
                print('Pas de connexion valide.')
                sys.exit(1)
            except SSHException as e:
                print(f'Erreur de connexion SSH : {e}')
                sys.exit(1)

        # si aucun serveur n'a trouvé la MAC, affiche un message et quitte avec erreur
        print("MAC address not found")
        sys.exit(1)

    else:
        # si la MAC n'est pas valide, affiche une erreur et quitte avec erreur
        print("error: bad MAC address.")
        sys.exit(1)


if __name__ == '__main__':
    main()
