from fabric import Connection
from paramiko.ssh_exception import NoValidConnectionsError, SSHException


def ip_other_mac_exists(cnx, ip, mac, cfg):
    try:
        # récupère le chemin du fichier de config dhcp
        file_config = cfg['dhcp_hosts_cfg']
        # exécute une commande grep pour lister toutes les lignes dhcp-host=
        result = cnx.run(f"sudo grep '^dhcp-host=' {file_config}", hide=True, warn=True)

        # découpe le résultat en lignes
        lignes = result.stdout.strip().split('\n')
        # parcourt chaque ligne
        for ligne in lignes:
            if ligne.startswith("dhcp-host="):
                # prend la partie après =
                contenu = ligne.split("=", 1)[1]
                # découpe en mac et ip
                parts = contenu.split(",")
                if len(parts) >= 2:
                    mac_cfg, ip_cfg = parts[0], parts[1]
                    # vérifie si l'IP est la même mais pas la MAC
                    if ip == ip_cfg and mac != mac_cfg:
                        return True
        # aucun conflit détecté
        return False

    # gestion des erreurs de connexion SSH
    except NoValidConnectionsError:
        print('Pas de connexion valide.')
    except SSHException as e:
        print(f'Erreur de connexion SSH : {e}')



def mac_exists(cnx, mac, cfg):
    try:
        # chemin du fichier dhcp
        file_config = cfg['dhcp_hosts_cfg']
        # cherche la ligne dhcp-host pour cette MAC
        result = cnx.run(f"sudo grep 'dhcp-host={mac},' {file_config}", hide=True, warn=True)

        # retourne True si trouvé, False sinon
        if result.stdout.strip() != "":
            return True
        return False

    except NoValidConnectionsError:
        print('Pas de connexion valide.')
    except SSHException as e:
        print(f'Erreur de connexion SSH : {e}')



def dhcp_add(ip, mac, server, cfg):
    # crée une connexion SSH
    cx = Connection(host=server, user='dhcp-mod')

    try:
        # vérifie que l'IP n'est pas prise par une autre MAC
        if ip_other_mac_exists(cx, ip, mac, cfg):
            return "Error: IP address already use by another MAC"

        # vérifie si la MAC existe déjà
        grep_cmd = f"sudo grep 'dhcp-host={mac},' {cfg['dhcp_hosts_cfg']}"
        result = cx.run(grep_cmd, hide=True, warn=True)

        if result.stdout:
            # si la MAC existe : modifier la ligne avec sed
            sed_cmd = f"sudo sed -i s#dhcp-host={mac},.*#dhcp-host={mac},{ip}# {cfg['dhcp_hosts_cfg']}"
            cx.run(sed_cmd)
            # redémarrer le service dnsmasq pour appliquer la conf
            cx.run("sudo systemctl restart dnsmasq")
            return "MAC updated with new IP"

        else:
            # sinon : ajouter une nouvelle ligne avec tee
            add_cmd = f"echo 'dhcp-host={mac},{ip}' | sudo tee -a {cfg['dhcp_hosts_cfg']} > /dev/null"
            cx.run(add_cmd)
            # redémarrer dnsmasq
            cx.run("sudo systemctl restart dnsmasq")
            return f"dhcp-host={mac},{ip} added"

    except NoValidConnectionsError:
        return 'Error: No valid connection'
    except SSHException as e:
        return f'Error: SSH connection failed: {e}'



def dhcp_remove(mac, server, cfg):
    try:
        # crée la connexion SSH
        cx = Connection(host=server, user='dhcp-mod')
        file_config = cfg['dhcp_hosts_cfg']

        # vérifie si la MAC est présente
        grep_cmd = f"sudo grep 'dhcp-host={mac},' {file_config}"
        result = cx.run(grep_cmd, hide=True, warn=True)

        if result.stdout.strip() == "":
            return f"Error: MAC address {mac} not found in configuration"

        # supprime la ligne et nettoie les lignes vides éventuelles
        sed_cmd = f"sudo sed -i s#^dhcp-host={mac},.*## {file_config}"
        cx.run(sed_cmd)

        # redémarre dnsmasq
        cx.run("sudo systemctl restart dnsmasq")
        return f"Configuration for MAC {mac} removed"

    except NoValidConnectionsError:
        return 'Error: No valid SSH connection'
    except SSHException as e:
        return f'SSH Error: {e}'



def dhcp_list(server, cfg):
    try:
        # crée la connexion SSH
        cx = Connection(host=server, user='dhcp-mod')
        file_config = cfg['dhcp_hosts_cfg']

        # récupère toutes les lignes dhcp-host=
        result = cx.run(f"sudo grep '^dhcp-host=' {file_config}", hide=True, warn=True)
        lignes = result.stdout.strip().split('\n')

        output = []
        # pour chaque ligne, découpe en mac et ip et ajoute au résultat
        for ligne in lignes:
            if ligne.startswith("dhcp-host="):
                contenu = ligne.split("=", 1)[1]
                parts = contenu.split(",")
                if len(parts) >= 2:
                    mac, ip = parts[0], parts[1]
                    output.append({"mac": mac, "ip": ip})

        return output

    except NoValidConnectionsError:
        print('Error: No valid SSH connection')
        return []
    except SSHException as e:
        print(f'SSH Error: {e}')
        return []
