#!/usr/bin/env python3


import sys
from dhcp import dhcp_list  
from config import load_config  
from fabric import Connection  
from paramiko.ssh_exception import NoValidConnectionsError, SSHException  


def main():

    # variable pour savoir si on fait une recherche sur un serveur spécifique
    code_recherche = 0

    # si un argument est passé => on fait une recherche spécifique
    if len(sys.argv) > 1:
        code_recherche = 1
    # si trop de paramètres => erreur
    if len(sys.argv) > 2:
        print("error: Too much parameters")
        sys.exit(1)

    # charger la configuration supervisée depuis le fichier YAML
    config = load_config('config_superviseur.yaml', True)

    # si on a un paramètre : on liste sur un seul serveur
    if code_recherche == 1:
        server = sys.argv[1]  # adresse ou nom du serveur
        cnx = Connection(host=server, user='dhcp-mod')  # crée la connexion SSH (non utilisée ici car dhcp_list le fait déjà)

        try:
            # appel de dhcp_list pour récupérer les paires MAC/IP
            result = dhcp_list(server, config)
            # pour chaque entrée, affiche MAC et IP formatées avec alignement
            for lignes in result:
                print(f"{lignes['mac']:<20} {lignes['ip']}")
            sys.exit(0)

        # gestion des erreurs SSH
        except NoValidConnectionsError:
            print('Pas de connexion valide.')
        except SSHException as e:
            print(f'Erreur de connexion SSH : {e}')

    # si aucun paramètre : on liste pour tous les serveurs supervisés
    else:
        # liste des serveurs définis dans le YAML
        servers = list(config.get("dhcp-servers", {}).keys())

        try:
            # pour chaque serveur
            for server in servers:
                print(f"{server}:")  # affiche le nom du serveur
                result = dhcp_list(server, config)  # liste les paires MAC/IP pour ce serveur
                for lignes in result:
                    print(f"{lignes['mac']:<20} {lignes['ip']}")  # affiche chaque paire
            sys.exit(0)


        except NoValidConnectionsError:
            print('Pas de connexion valide.')
        except SSHException as e:
            print(f'Erreur de connexion SSH : {e}')



if __name__ == '__main__':
    main()
