import ipaddress

# vérifie si une adresse IPv4 est valide et pas spéciale
def if_ipv4valide(ip):
    try:
        ip = ipaddress.IPv4Address(ip)  # essaye de créer un objet IPv4
        # refuse si l'ip est vide, loopback, multicast, locale ou réservée
        if ip.is_unspecified or ip.is_loopback or ip.is_multicast or ip.is_link_local or ip.is_reserved:
            return False
        return True  # sinon c'est ok
    except ValueError:
        # erreur si le format n'est pas une ip valide
        return False

# liste des caractères valides pour une adresse MAC
carac = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
         'a', 'b', 'c', 'd', 'e', 'f',
         'A', 'B', 'C', 'D', 'E', 'F']

# vérifie si une adresse MAC est au bon format
def if_macvalide(mac):
    a = mac.split(':')  # coupe la mac en morceaux séparés par ':'
    if len(a) != 6:
        # doit avoir 6 parties
        return False
    for value in a:
        if len(value) != 2:
            # chaque partie doit avoir 2 caractères
            return False
        for charac in value:
            if charac not in carac:
                # chaque caractère doit être un chiffre ou une lettre hexadécimale
                return False
    return True 
